/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;


import java.util.Iterator;
import java.util.NoSuchElementException;


/**
 * Provides read only access to a collection of {@link MgLayerBase} objects.
 *
 */
 public class MgReadOnlyLayerCollection extends MgGuardDisposable implements java.lang.Iterable<MgLayerBase> {
  private long swigCPtr;

  public MgReadOnlyLayerCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgReadOnlyLayerCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgReadOnlyLayerCollection() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgReadOnlyLayerCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgReadOnlyLayerCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

    /**
     * An iterator to iterate over this collection
     */
    class ItemIterator implements Iterator<MgLayerBase> {
        private MgReadOnlyLayerCollection _collection;
        private int _pos;
        private int _count;
        
        public ItemIterator(MgReadOnlyLayerCollection c) { 
            _collection = c; 
            _count = _collection.getCount();
            _pos = -1;
        }
        
        /**
         * Returns true if the iteration has more elements
         */
        public boolean hasNext() {
            return _pos + 1 < _count;
        }
        
        /**
         * Returns the next MgLayerBase in the collection
         */
        public MgLayerBase next() {
            _pos++;
            if (_pos >= _count)
                throw new NoSuchElementException();
            return _collection.getItem(_pos);
        }
        
        /**
         * Removes from the underlying collection the last element returned by the iterator (not supported).
         */
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /**
     * Returns an iterator over the elements in this collection.
     */
    public Iterator<MgLayerBase> iterator() { return new ItemIterator(this); }
    

  
/**
 * Gets the number of layers in the collection.
 *
 * @return  Returns the number of layers.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgReadOnlyLayerCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the layer at the specified index.
 *
 * @param  index (int)  Index of the layer to get.
 * @return  Returns the layer.
 * @exception  MgOutOfRangeException if the index is invalid.
 */
 public MgLayerBase getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgReadOnlyLayerCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgLayerBase)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Determines if the collection contains the specified layer.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean contains(MgLayerBase value) {
    return MapGuideJavaApiExJNI.MgReadOnlyLayerCollection_Contains(swigCPtr, MgLayerBase.getCPtr(value));
  }

  
/**
 * Gets the index of the specified layer in the collection.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to search for.
 * @return  Returns the layer's index if the collection contains the
 *  specified layer, or false (-1) otherwise.
 */
 public int indexOf(MgLayerBase value) {
    return MapGuideJavaApiExJNI.MgReadOnlyLayerCollection_IndexOf(swigCPtr, MgLayerBase.getCPtr(value));
  }

}
