/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Provides a forward-only, read-only iterator for reading data.
 * You must call ReadNext before you can access any data. This
 * is a base class for {@link MgDataReader}, {@link MgFeatureReader}, and
 * {@link MgSqlDataReader}.
 *
 */
 public class MgReader extends MgSerializable {
  private long swigCPtr;

  public MgReader(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgReaderToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgReader() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgReader(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgReader obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Advances the reader to the next item and determines whether
 * there is another object to read.
 *
 * @return  Returns true if there is a next item; otherwise returns
 *  false.
 */
 public boolean readNext() {
    return MapGuideJavaApiExJNI.MgReader_ReadNext(swigCPtr);
  }

  
/**
 * Gets the number of properties in the feature currently being
 * read.
 *
 * @return  Returns the number of properties.
 */
 public int getPropertyCount() {
    return MapGuideJavaApiExJNI.MgReader_GetPropertyCount(swigCPtr);
  }

  
/**
 * Gets the name of the property at the given ordinal position.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the property name.
 * @since  2.2 */
 public String getPropertyName(int index) {
  { return MapGuideJavaApiExJNI.MgReader_GetPropertyName(swigCPtr, index); }
}

  
/**
 * Gets the type of the property with the specified name. See
 * {@link MgPropertyType} for the list of possible values.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns an {@link MgPropertyType} value.
 */
 public int getPropertyType(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_GetPropertyType__SWIG_0(swigCPtr, propertyName);
  }

  
/**
 * Gets the type of the property at the specified index. See
 * {@link MgPropertyType} for the list of possible values.
 *
 * @param  index (index)  The property index.
 * @return  Returns an {@link MgPropertyType} value.
 * @since  2.2 */
 public int getPropertyType(int index) {
    return MapGuideJavaApiExJNI.MgReader_GetPropertyType__SWIG_1(swigCPtr, index);
  }

  
/**
 * Determines whether the value of the specified property is
 * null.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns true if the value is null; otherwise returns false.
 */
 public boolean isNull(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_IsNull__SWIG_0(swigCPtr, propertyName);
  }

  
/**
 * Gets the Boolean value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the Boolean value.
 * @exception  MgInvalidPropertyTypeException
 */
 public boolean getBoolean(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_GetBoolean__SWIG_0(swigCPtr, propertyName);
  }

  
/**
 * Gets the Byte value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the Byte value.
 * @exception  MgInvalidPropertyTypeException
 */
 public short getByte(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_GetByte__SWIG_0(swigCPtr, propertyName);
  }

  
/**
 * Gets the {@link MgDateTime} value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns an {@link MgDateTime} object.
 * @exception  MgInvalidPropertyTypeException
 */
 public MgDateTime getDateTime(String propertyName) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetDateTime__SWIG_0(swigCPtr, propertyName);
    return (cPtr == 0) ? null : (MgDateTime)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the Single value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the single value.
 * @exception  MgInvalidPropertyTypeException
 */
 public float getSingle(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_GetSingle__SWIG_0(swigCPtr, propertyName);
  }

  
/**
 * Gets the Double value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the double value.
 * @exception  MgInvalidPropertyTypeException
 */
 public double getDouble(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_GetDouble__SWIG_0(swigCPtr, propertyName);
  }

  
/**
 * Gets the 16 bit integer value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the 16 bit integer value.
 * @exception  MgInvalidPropertyTypeException
 */
 public short getInt16(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_GetInt16__SWIG_0(swigCPtr, propertyName);
  }

  
/**
 * Gets the 32 bit integer value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the integer 32 bits value.
 * @exception  MgInvalidPropertyTypeException
 */
 public int getInt32(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_GetInt32__SWIG_0(swigCPtr, propertyName);
  }

  
/**
 * Gets the 64 bit integer value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the integer 64 bits value.
 * @exception  MgInvalidPropertyTypeException
 */
 public long getInt64(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_GetInt64__SWIG_0(swigCPtr, propertyName);
  }

  
/**
 * Gets the string value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the string value.
 * @exception  MgInvalidPropertyTypeException
 */
 public String getString(String propertyName) {
  { return MapGuideJavaApiExJNI.MgReader_GetString__SWIG_0(swigCPtr, propertyName); }
}

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the BLOB value in an {@link MgByteReader} object.
 * @exception  MgInvalidPropertyTypeException
 */
 public MgByteReader getBLOB(String propertyName) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetBLOB__SWIG_0(swigCPtr, propertyName);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the CLOB value of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns the CLOB value in an {@link MgByteReader} object.
 * @exception  MgInvalidPropertyTypeException
 */
 public MgByteReader getCLOB(String propertyName) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetCLOB__SWIG_0(swigCPtr, propertyName);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the Geometry for the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns a geometry in AGF binary format in an {@link MgByteReader}
 *  object.
 * @exception  MgInvalidPropertyTypeException
 */
 public MgByteReader getGeometry(String propertyName) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetGeometry__SWIG_0(swigCPtr, propertyName);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the raster object of the specified property.
 *
 * @param  propertyName (String/string)  The property name.
 * @return  Returns an {@link MgRaster} object.
 * @exception  MgConnectionNotOpenException MgNullPropertyValueException
 * @exception  MgFdoException MgInvalidPropertyTypeException
 * @exception  MgInvalidPropertyTypeException
 */
 public MgRaster getRaster(String propertyName) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetRaster__SWIG_0(swigCPtr, propertyName);
    return (cPtr == 0) ? null : (MgRaster)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the index of the property with the specified property name.
 *
 * @param  propertyName (String/string)  The name of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the property index.
 * @since  2.2 */
 public int getPropertyIndex(String propertyName) {
    return MapGuideJavaApiExJNI.MgReader_GetPropertyIndex(swigCPtr, propertyName);
  }

  
/**
 * Determines whether the value of the specified property is
 * null.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns true if the value is null; otherwise returns false.
 * @since  2.2 */
 public boolean isNull(int index) {
    return MapGuideJavaApiExJNI.MgReader_IsNull__SWIG_1(swigCPtr, index);
  }

  
/**
 * Gets the Boolean value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the Boolean value.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public boolean getBoolean(int index) {
    return MapGuideJavaApiExJNI.MgReader_GetBoolean__SWIG_1(swigCPtr, index);
  }

  
/**
 * Gets the Byte value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the Byte value.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public short getByte(int index) {
    return MapGuideJavaApiExJNI.MgReader_GetByte__SWIG_1(swigCPtr, index);
  }

  
/**
 * Gets the {@link MgDateTime} value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns an {@link MgDateTime} object.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public MgDateTime getDateTime(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetDateTime__SWIG_1(swigCPtr, index);
    return (cPtr == 0) ? null : (MgDateTime)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the Single value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the single value.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public float getSingle(int index) {
    return MapGuideJavaApiExJNI.MgReader_GetSingle__SWIG_1(swigCPtr, index);
  }

  
/**
 * Gets the Double value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the double value.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public double getDouble(int index) {
    return MapGuideJavaApiExJNI.MgReader_GetDouble__SWIG_1(swigCPtr, index);
  }

  
/**
 * Gets the 16 bit integer value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the 16 bit integer value.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public short getInt16(int index) {
    return MapGuideJavaApiExJNI.MgReader_GetInt16__SWIG_1(swigCPtr, index);
  }

  
/**
 * Gets the 32 bit integer value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the integer 32 bits value.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public int getInt32(int index) {
    return MapGuideJavaApiExJNI.MgReader_GetInt32__SWIG_1(swigCPtr, index);
  }

  
/**
 * Gets the 64 bit integer value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the integer 64 bits value.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public long getInt64(int index) {
    return MapGuideJavaApiExJNI.MgReader_GetInt64__SWIG_1(swigCPtr, index);
  }

  
/**
 * Gets the string value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the string value.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public String getString(int index) {
  { return MapGuideJavaApiExJNI.MgReader_GetString__SWIG_1(swigCPtr, index); }
}

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the BLOB value in an {@link MgByteReader} object.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public MgByteReader getBLOB(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetBLOB__SWIG_1(swigCPtr, index);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the CLOB value of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns the CLOB value in an {@link MgByteReader} object.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public MgByteReader getCLOB(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetCLOB__SWIG_1(swigCPtr, index);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the Geometry for the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns a geometry in AGF binary format in an {@link MgByteReader}
 *  object.
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public MgByteReader getGeometry(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetGeometry__SWIG_1(swigCPtr, index);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the raster object of the specified property.
 *
 * @param  index (int)  The position of the property in the list of  properties belonging to the feature currently  being read.
 * @return  Returns an {@link MgRaster} object.
 * @exception  MgConnectionNotOpenException MgNullPropertyValueException
 * @exception  MgFdoException MgInvalidPropertyTypeException
 * @exception  MgInvalidPropertyTypeException
 * @since  2.2 */
 public MgRaster getRaster(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgReader_GetRaster__SWIG_1(swigCPtr, index);
    return (cPtr == 0) ? null : (MgRaster)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Closes the object, freeing any resources it may be holding.
 *
 * @return  Returns nothing.
 */
 public void close() {
    MapGuideJavaApiExJNI.MgReader_Close(swigCPtr);
  }

  
/**
 * Get the type of this reader. See {@link MgReaderType} for a list of
 * the possible values.
 *
 * @return  Returns an {@link MgReaderType} value.
 */
 public int getReaderType() {
    return MapGuideJavaApiExJNI.MgReader_GetReaderType(swigCPtr);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Serializes the unread features in the reader into an XML format.
 * The XML format of the output is governed by the {@link MgFeatureSet}
 * schema.
 *
 * @return  {@link MgByteReader} holding XML.
 */
 public MgByteReader toXml() {
    long cPtr = MapGuideJavaApiExJNI.MgReader_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
