/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Enables you to manipulate repositories and resources.
 *
 */
 public class MgResourceService extends MgService {
  private long swigCPtr;

  public MgResourceService(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgResourceServiceToMgService(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgResourceService() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgResourceService(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgResourceService obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  Repository to update.
 * @param  content ({@link MgByteReader})
 * @param  header ({@link MgByteReader})  <ul>     <li>If the repository is the library, this is the
 * @return  Returns nothing.
 * @exception  MgOutOfMemoryException
 * @exception  MgRepositoryNotFoundException if repository does not
 * @exception  MgInvalidRepositoryTypeException
 */
 public void updateRepository(MgResourceIdentifier resource, MgByteReader content, MgByteReader header) {
    MapGuideJavaApiExJNI.MgResourceService_UpdateRepository(swigCPtr, MgResourceIdentifier.getCPtr(resource), MgByteReader.getCPtr(content), MgByteReader.getCPtr(header));
  }

  
/**
 * Applies a package of resource changes to the repository.
 *
 * @param  resourcePackage ({@link MgByteReader})  The package containing resources to update.
 * @return  Returns nothing.
 * @exception  MgNullArgumentException
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 * @exception  MgOutOfMemoryException
 */
 public void applyResourcePackage(MgByteReader resourcePackage) {
    MapGuideJavaApiExJNI.MgResourceService_ApplyResourcePackage(swigCPtr, MgByteReader.getCPtr(resourcePackage));
  }

  
/**
 * Enumerates the resources in the specified repository.
 *
 * @param  resource ({@link MgResourceIdentifier})  Resource identifier specifying the resource to  enumerate. This can be a document or a folder.
 * @param  depth (int)  Recursion depth, relative to the specified resource.  <ul>      <li>If the resource is a document, depth must be set to           0.      </li>      <li>If the resource is a folder:      </li>      <ul>          <li>If the depth is equal to 0, only information about               the specified folder is returned.          </li>          <li>If the depth is greater than 0, information about               the folder and its descendants up to the specified               depth are returned.          </li>      </ul>      <li>If the depth is -1, information about the folder           and all its descendants is returned.      </li>  </ul>
 * @param  type (String/string)  Type of the resource to be enumerated. (Case
 * @return  Returns an {@link MgByteReader} object containing a description of
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 */
 public MgByteReader enumerateResources(MgResourceIdentifier resource, int depth, String type) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_EnumerateResources__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), depth, type);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Enumerates the resources in the specified repository.
 *
 * @param  resource ({@link MgResourceIdentifier})  Resource identifier specifying the resource to  enumerate. This can be a document or a folder.
 * @param  depth (int)  Recursion depth, relative to the specified resource.  <ul>      <li>If the resource is a document, depth must be set to           0.      </li>      <li>If the resource is a folder:      </li>      <ul>          <li>If the depth is equal to 0, only information about               the specified folder is returned.          </li>          <li>If the depth is greater than 0, information about               the folder and its descendants up to the specified               depth are returned.          </li>      </ul>      <li>If the depth is -1, information about the folder           and all its descendants is returned.      </li>  </ul>
 * @param  type (String/string)  Type of the resource to be enumerated. (Case
 * @param  computeChildren (boolean/bool)  Flag to determine whether or not the number of children of the leaf folder  resource at the specified depth should be computed.  <ul>      <li>If it is true, then the number of children of the leaf folder           resource at the specified depth will be set to a computed value (>= 0).      </li>      <li>If it is false, then the number of children of the leaf folder           resource at the specified depth will be set to -1.      </li>  </ul>
 * @return  Returns an {@link MgByteReader} object containing a description of
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 * @since  2.0 */
 public MgByteReader enumerateResources(MgResourceIdentifier resource, int depth, String type, boolean computeChildren) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_EnumerateResources__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), depth, type, computeChildren);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Adds a new resource to a resource repository, or updates an
 * existing resource.
 *
 * @param  resource ({@link MgResourceIdentifier})  Location where the resource will be placed in the  repository.
 * @param  content ({@link MgByteReader})  The resource content in XML format using the schema
 * @param  header ({@link MgByteReader})
 * @return  Returns nothing.
 * @exception  MgInvalidResourceTypeException
 */
 public void setResource(MgResourceIdentifier resource, MgByteReader content, MgByteReader header) {
    MapGuideJavaApiExJNI.MgResourceService_SetResource(swigCPtr, MgResourceIdentifier.getCPtr(resource), MgByteReader.getCPtr(content), MgByteReader.getCPtr(header));
  }

  
/**
 * Deletes an existing resource and its associated data from the
 * repository.
 *
 * @param  resource ({@link MgResourceIdentifier})  Resource identifier specifying the resource to
 * @return  Returns nothing.
 * @exception  MgInvalidResourceTypeException
 */
 public void deleteResource(MgResourceIdentifier resource) {
    MapGuideJavaApiExJNI.MgResourceService_DeleteResource(swigCPtr, MgResourceIdentifier.getCPtr(resource));
  }

  
/**
 * Moves an existing resource to another location.
 *
 * @param  sourceResource ({@link MgResourceIdentifier})  Resource to be moved. This can be a document  or folder.  <ul>     <li>If it is a folder, this method also moves the contents of the folder and all folders below it.</li>     <li>If it is a folder, you must include the trailing slash in the identifier.</li>  </ul>
 * @param  destResource ({@link MgResourceIdentifier})  Where the resource should be moved to.
 * @param  overwrite (boolean/bool)  Flag to determine whether or not the  destination resource should be overwritten if  it exists.
 * @return  Returns nothing.
 * @exception  MgResourceNotFoundException
 * @exception  MgDuplicateResourceException
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 */
 public void moveResource(MgResourceIdentifier sourceResource, MgResourceIdentifier destResource, boolean overwrite) {
    MapGuideJavaApiExJNI.MgResourceService_MoveResource__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(sourceResource), MgResourceIdentifier.getCPtr(destResource), overwrite);
  }

  
/**
 * Moves an existing resource to another location.
 *
 * @param  sourceResource ({@link MgResourceIdentifier})  Resource to be moved. This can be a document  or folder.  <ul>     <li>If it is a folder, this method also moves the contents of the folder and all folders below it.</li>     <li>If it is a folder, you must include the trailing slash in the identifier.</li>  </ul>
 * @param  destResource ({@link MgResourceIdentifier})  Where the resource should be moved to.
 * @param  overwrite (boolean/bool)  Flag to determine whether or not the  destination resource should be overwritten if  it exists.
 * @param  cascade (boolean/bool)  Flag to determine whether or not the  referencing resources should be updated.
 * @return  Returns nothing.
 * @exception  MgResourceNotFoundException
 * @exception  MgDuplicateResourceException
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 * @since  2.2 */
 public void moveResource(MgResourceIdentifier sourceResource, MgResourceIdentifier destResource, boolean overwrite, boolean cascade) {
    MapGuideJavaApiExJNI.MgResourceService_MoveResource__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(sourceResource), MgResourceIdentifier.getCPtr(destResource), overwrite, cascade);
  }

  
/**
 * Copies an existing resource to another location.
 *
 * @param  sourceResource ({@link MgResourceIdentifier})  Resource to be copied from. This can be a  document or folder.
 * @param  destResource ({@link MgResourceIdentifier})  Where the resource should be copied to.
 * @param  overwrite (boolean/bool)  Flag to determine whether or not the  destination resource should be overwritten if  it exists.
 * @return  Returns nothing.
 * @exception  MgResourceNotFoundException
 * @exception  MgDuplicateResourceException
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 */
 public void copyResource(MgResourceIdentifier sourceResource, MgResourceIdentifier destResource, boolean overwrite) {
    MapGuideJavaApiExJNI.MgResourceService_CopyResource(swigCPtr, MgResourceIdentifier.getCPtr(sourceResource), MgResourceIdentifier.getCPtr(destResource), overwrite);
  }

  
/**
 * Gets the content of the specified resource.
 *
 * @param  resource ({@link MgResourceIdentifier})  Resource identifier specifying  the resource.
 * @return  Returns an {@link MgByteReader} object containing the resource
 *  content in XML format. The XML uses the schema appropriate
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 */
 public MgByteReader getResourceContent(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_GetResourceContent(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the contents of the specified resources.
 *
 * @param  resources  A collection of resource identifiers describing the resources.
 * @param  preProcessTags  Pre-processing to apply to resource before returning content.  If this parameter is NULL, it means no pre-processing.  If this parameter is not NULL, it must be a collection of pre-processing types, and it should be  one to one matching the collection of parameter resources.  See {@link MgResourcePreProcessingType} for a list of supported pre-processing tags.
 * @return  {@link MgStringCollection} object representing the collection of corresponding resource contents.
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 * @since  2.2 */
 public MgStringCollection getResourceContents(MgStringCollection resources, MgStringCollection preProcessTags) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_GetResourceContents(swigCPtr, MgStringCollection.getCPtr(resources), MgStringCollection.getCPtr(preProcessTags));
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  Resource to get the header  for.
 * @return  Returns an {@link MgByteReader} object containing the resource
 * @exception  MgInvalidResourceTypeException
 */
 public MgByteReader getResourceHeader(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_GetResourceHeader(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  Resource whose owner is to be changed. This
 * @param  owner (String/string)  The User ID of the new owner. (The User ID must  already exist. You can create User IDs through  the Site Administrator tool.)
 * @param  includeDescendants (boolean/bool)  Flag to determine whether or not the owners of  descendant resources should be also be changed.  This flag is applicable only if the resource is  a folder.
 * @return  Returns nothing.
 * @exception  MgPermissionDeniedException
 * @exception  MgResourceNotFoundException
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 */
 public void changeResourceOwner(MgResourceIdentifier resource, String owner, boolean includeDescendants) {
    MapGuideJavaApiExJNI.MgResourceService_ChangeResourceOwner(swigCPtr, MgResourceIdentifier.getCPtr(resource), owner, includeDescendants);
  }

  
/**
 * Sets the permissions for all descendants of a specified
 * folder to be inherited from the folder.
 *
 * @param  resource ({@link MgResourceIdentifier})  Folder that permissions are to be inherited  from. You must include the trailing slash in  the identifier.
 * @return  Returns nothing.
 * @exception  MgPermissionDeniedException
 * @exception  MgResourceNotFoundException
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 */
 public void inheritPermissionsFrom(MgResourceIdentifier resource) {
    MapGuideJavaApiExJNI.MgResourceService_InheritPermissionsFrom(swigCPtr, MgResourceIdentifier.getCPtr(resource));
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  Resource to which this data is to be associated.
 * @param  dataName (String/string)  Name for the data.
 * @param  dataType (String/string)  Data type for the resource data. It must match one  of the types defined in {@link MgResourceDataType} and is  case sensitive. Data names must be unique.
 * @param  data ({@link MgByteReader})  Data to set.
 * @return  Returns nothing.
 *  <!-- Examples (PHP) -->
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidResourceTypeException if resource is a folder type
 * @exception  MgInvalidResourceDataTypeException if the specified
 */
 public void setResourceData(MgResourceIdentifier resource, String dataName, String dataType, MgByteReader data) {
    MapGuideJavaApiExJNI.MgResourceService_SetResourceData(swigCPtr, MgResourceIdentifier.getCPtr(resource), dataName, dataType, MgByteReader.getCPtr(data));
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  The resource for which the resource data  will be deleted.
 * @param  dataName (String/string)  Name for data.
 * @return  Returns nothing.
 * @exception  MgInvalidResourceTypeException
 */
 public void deleteResourceData(MgResourceIdentifier resource, String dataName) {
    MapGuideJavaApiExJNI.MgResourceService_DeleteResourceData(swigCPtr, MgResourceIdentifier.getCPtr(resource), dataName);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  The resource for which the resource  data will be renamed.
 * @param  oldDataName (String/string)  Old data name.
 * @param  newDataName (String/string)  New data name.
 * @param  overwrite (boolean/bool)  Flag to determine whether or not  the destination resource data  should be overwritten if it exists.
 * @return  Returns nothing.
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidResourceTypeException
 * @exception  MgInvalidResourceDataTypeException
 * @exception  MgResourceDataNotFoundException
 * @exception  MgDuplicateResourceDataException
 */
 public void renameResourceData(MgResourceIdentifier resource, String oldDataName, String newDataName, boolean overwrite) {
    MapGuideJavaApiExJNI.MgResourceService_RenameResourceData(swigCPtr, MgResourceIdentifier.getCPtr(resource), oldDataName, newDataName, overwrite);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  The resource for which the resource data will  be obtained.
 * @param  dataName (String/string)  Name for data (as specified when the data was
 * @return  Returns an {@link MgByteReader} object containing the resource data.
 * @exception  MgResourceDataNotFoundException
 * @exception  MgInvalidResourceTypeException
 */
 public MgByteReader getResourceData(MgResourceIdentifier resource, String dataName) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_GetResourceData(swigCPtr, MgResourceIdentifier.getCPtr(resource), dataName);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  The resource for which the resource  data will be listed.
 * @return  Returns an {@link MgByteReader} object representing the description
 * @exception  MgInvalidResourceTypeException
 */
 public MgByteReader enumerateResourceData(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_EnumerateResourceData(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  Repository to get the content  for.
 * @return  Returns an {@link MgByteReader} object containing the repository
 * @exception  MgRepositoryNotFoundException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidRepositoryTypeException
 */
 public MgByteReader getRepositoryContent(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_GetRepositoryContent(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  resource ({@link MgResourceIdentifier})  Repository to get the header  for.
 * @return  Returns an {@link MgByteReader} object containing the repository
 * @exception  MgRepositoryNotFoundException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidRepositoryTypeException
 */
 public MgByteReader getRepositoryHeader(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_GetRepositoryHeader(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Enumerates all the resources which reference the specified
 * resource.
 *
 * @param  resource ({@link MgResourceIdentifier})  Resource to get references  for.
 * @return  Returns an {@link MgByteReader} object containing the list of all
 *  resources which reference the specified resource. The list is
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidRepositoryNameException
 * @exception  MgInvalidResourcePathException
 * @exception  MgInvalidResourceNameException
 * @exception  MgInvalidResourceTypeException
 */
 public MgByteReader enumerateReferences(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_EnumerateReferences(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Checks to see if the specified resource exists.
 *
 * @param  resource ({@link MgResourceIdentifier})  Resource identifier specifying the resource to be checked for existence.
 * @return  Returns true if the resource exists, false otherwise.
 */
 public boolean resourceExists(MgResourceIdentifier resource) {
    return MapGuideJavaApiExJNI.MgResourceService_ResourceExists(swigCPtr, MgResourceIdentifier.getCPtr(resource));
  }

  
/**
 * Enumerate unmanaged data
 *
 * @param  path (String/string)  Unmanaged data path
 * @param  recursive (boolean/bool)  Flag to determine whether to recurse subfolders or not
 * @param  type (String/string)  Folders, Files, or Both
 * @param  filter (String/string)  file filter to be used on returned files
 * @return  Returns an {@link MgByteReader} object containing the unmanaged data
 * @since  1.2 */
 public MgByteReader enumerateUnmanagedData(String path, boolean recursive, String type, String filter) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_EnumerateUnmanagedData(swigCPtr, path, recursive, type, filter);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Enumerate the resource documents in the specified repository.
 *
 * @param  resources  Resource identifiers specifying the resources to enumerate.
 * @param  type  Type of the resource to be enumerated. See {@link MgResourceType} for valid types.  No folder type is allowed.
 * @param  properties  Flag to specify which properties of the resource header should be filtered.  It may be set to 0 or by bitwise inclusively OR'ing together one or  more of the {@link MgResourceHeaderProperties} values.
 * @return  Returns a string containing a description of the WMS layer definitions
 * @exception  MgInvalidResourceTypeException
 */
 public String enumerateResourceDocuments(MgStringCollection resources, String type, int properties) {
  { return MapGuideJavaApiExJNI.MgResourceService_EnumerateResourceDocuments(swigCPtr, MgStringCollection.getCPtr(resources), type, properties); }
}

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Returns the modified date of the specified resource.
 *
 * @param  resource ({@link MgResourceIdentifier})  Resource to get the modified date for.
 * @return  An {@link MgDateTime} object containing the modified date of the resource.
 * @exception  MgInvalidRepositoryTypeException
 * @exception  MgInvalidResourceTypeException
 */
 public MgDateTime getResourceModifiedDate(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_GetResourceModifiedDate(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgDateTime)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Sets the Metadata content for an existing resource.
 *
 * @param  resource ({@link MgResourceIdentifier})  The resource in the repository that gets metadata attached to. Note the resource has to exist else this method fails
 * @param  content ({@link MgByteReader})  The metadata content in XML format. This can be set to  null, in which case the content is cleared.  The schema of the Content is user driven and not given. Most people will use it for FGDC or ISO Metadata.
 * @return  Returns nothing.
 * @exception  MgInvalidResourceTypeException
 */
 public void setResourceMetadata(MgResourceIdentifier resource, MgByteReader content) {
    MapGuideJavaApiExJNI.MgResourceService_SetResourceMetadata(swigCPtr, MgResourceIdentifier.getCPtr(resource), MgByteReader.getCPtr(content));
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Gets the Metadata content of a resource.
 *
 * @param  resource ({@link MgResourceIdentifier})  The resource in the repository which has metadata attached to it. Note the resource has to exist else this method fails.
 * @return  The metadata content in XML format. This can null in which case the resource has no metadata attached.
 *  The schema of the Content is user driven and not given. Most people will use it for FGDC or ISO Metadata.
 * @exception  MgInvalidResourceTypeException
 */
 public MgByteReader getResourceMetadata(MgResourceIdentifier resource) {
    long cPtr = MapGuideJavaApiExJNI.MgResourceService_GetResourceMetadata(swigCPtr, MgResourceIdentifier.getCPtr(resource));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
