/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public class MgSelectionBase extends MgResource {
  private long swigCPtr;

  public MgSelectionBase(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgSelectionBaseToMgResource(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgSelectionBase() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgSelectionBase(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgSelectionBase obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Initialize selection generation from a map
 *
 */
 public MgSelectionBase(MgMapBase map) {
    this(MapGuideJavaApiExJNI.new_MgSelectionBase__SWIG_0(MgMapBase.getCPtr(map)), true);
  }

  
/**
 * Initialize selection from a map and xml selection
 *
 */
 public MgSelectionBase(MgMapBase map, String xmlSelectionString) {
    this(MapGuideJavaApiExJNI.new_MgSelectionBase__SWIG_1(MgMapBase.getCPtr(map), xmlSelectionString), true);
  }

  
/**
 * Returns the number of selected features.
 *
 * @param  layer ({@link MgLayerBase})  Input layer.
 * @param  className (String/string)  Input feature class name.
 * @return  Returns Count of all selected features.
 * @since  2.0 */
 public int getSelectedFeaturesCount(MgLayerBase layer, String className) {
    return MapGuideJavaApiExJNI.MgSelectionBase_GetSelectedFeaturesCount(swigCPtr, MgLayerBase.getCPtr(layer), className);
  }

  
/**
 * Returns the selected feature data for the specified feature class.
 *
 * @param  layer ({@link MgLayerBase})  Input layer.
 * @param  className (String/string)  Input feature class name.
 * @param  mappedOnly (boolean/bool)  Return mapped (true) or all (false) properties for selected features
 * @return  Returns a feature reader containing all the features for the given
 *  feature class in this selection.
 * @since  2.0 */
 public MgFeatureReader getSelectedFeatures(MgLayerBase layer, String className, boolean mappedOnly) {
    long cPtr = MapGuideJavaApiExJNI.MgSelectionBase_GetSelectedFeatures__SWIG_0(swigCPtr, MgLayerBase.getCPtr(layer), className, mappedOnly);
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  layer ({@link MgLayerBase})  Input layer.
 * @param  className (String/string)  Input feature class name.
 * @param  propertyNames ({@link MgStringCollection})  Properties to return for selected features.
 * @return  Returns a feature reader containing all the features for the given
 *  feature class in this selection.
 * @since  2.0 */
 public MgFeatureReader getSelectedFeatures(MgLayerBase layer, String className, MgStringCollection propertyNames) {
    long cPtr = MapGuideJavaApiExJNI.MgSelectionBase_GetSelectedFeatures__SWIG_1(swigCPtr, MgLayerBase.getCPtr(layer), className, MgStringCollection.getCPtr(propertyNames));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Read selection from XML document.  Previous selection is cleared.
 *
 */
 public void fromXml(String xmlSelectionString) {
    MapGuideJavaApiExJNI.MgSelectionBase_FromXml(swigCPtr, xmlSelectionString);
  }

  
/**
 * Write selection as XML document.  This document will typically
 * be passed back to a viewer to select the desired features.
 *
 */
 public String toXml() {
  { return MapGuideJavaApiExJNI.MgSelectionBase_ToXml(swigCPtr); }
}

  
/**
 * Add nFeatures to selection set from the FeatureReader.
 * Specify nFeatures = 0 for all features in reader.
 * Internal identity mapping for layer dictates the properties used
 *
 */
 public void addFeatures(MgLayerBase layer, MgFeatureReader features, int nFeatures) {
    MapGuideJavaApiExJNI.MgSelectionBase_AddFeatures(swigCPtr, MgLayerBase.getCPtr(layer), MgFeatureReader.getCPtr(features), nFeatures);
  }

  
/**
 * Add a single selection to the set based on a collection of identity properties
 *
 */
 public void addFeatureIds(MgLayerBase layer, String className, MgPropertyCollection identityProperties) {
    MapGuideJavaApiExJNI.MgSelectionBase_AddFeatureIds(swigCPtr, MgLayerBase.getCPtr(layer), className, MgPropertyCollection.getCPtr(identityProperties));
  }

  
/**
 * Add a single selection to the set where the identity property is a 16-bit integer.
 *
 */
 public void addFeatureIdInt16(MgLayerBase layer, String className, short identifier) {
    MapGuideJavaApiExJNI.MgSelectionBase_AddFeatureIdInt16(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Add a single selection to the set where the identity property is a 32-bit integer.
 *
 */
 public void addFeatureIdInt32(MgLayerBase layer, String className, int identifier) {
    MapGuideJavaApiExJNI.MgSelectionBase_AddFeatureIdInt32(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Add a single selection to the set where the identity property is a 64-bit integer.
 *
 */
 public void addFeatureIdInt64(MgLayerBase layer, String className, long identifier) {
    MapGuideJavaApiExJNI.MgSelectionBase_AddFeatureIdInt64(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Add a single selection to the set where the identity property is a string.
 *
 */
 public void addFeatureIdString(MgLayerBase layer, String className, String identifier) {
    MapGuideJavaApiExJNI.MgSelectionBase_AddFeatureIdString(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Add a single selection to the set where the identity property is a double.
 *
 */
 public void addFeatureIdDouble(MgLayerBase layer, String className, double identifier) {
    MapGuideJavaApiExJNI.MgSelectionBase_AddFeatureIdDouble(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Returns list of selected layers
 *
 */
 public MgReadOnlyLayerCollection getLayers() {
    long cPtr = MapGuideJavaApiExJNI.MgSelectionBase_GetLayers(swigCPtr);
    return (cPtr == 0) ? null : (MgReadOnlyLayerCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns list of selected classes for a layer
 *
 */
 public MgStringCollection getClasses(String layer) {
    long cPtr = MapGuideJavaApiExJNI.MgSelectionBase_GetClasses(swigCPtr, layer);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the class name for the layer
 *
 */
 public String getClass(String layer) {
  { return MapGuideJavaApiExJNI.MgSelectionBase_GetClass(swigCPtr, layer); }
}

  
/**
 * Does a particular layer and class have selections.
 *
 */
 public boolean contains(MgLayerBase layer, String className) {
    return MapGuideJavaApiExJNI.MgSelectionBase_Contains(swigCPtr, MgLayerBase.getCPtr(layer), className);
  }

  
/**
 * Generates an Fdo filter text for the selections of the
 * specified layer and class
 *
 */
 public String generateFilter(MgLayerBase layer, String className) {
  { return MapGuideJavaApiExJNI.MgSelectionBase_GenerateFilter(swigCPtr, MgLayerBase.getCPtr(layer), className); }
}

  
/**
 * Generates a collection of FDO filter strings for the selections
 * of the specified layer and class
 *
 * @return  Returns the collection of FDO filter strings
 */
 public MgStringCollection generateFilters(MgLayerBase layer, String className, int selectionSize) {
    long cPtr = MapGuideJavaApiExJNI.MgSelectionBase_GenerateFilters(swigCPtr, MgLayerBase.getCPtr(layer), className, selectionSize);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the extents of the selection set.
 *
 * @param  featureService ({@link MgFeatureService})  {@link MgFeatureService} that can be used to retrieve the extents  for each feature class definition
 * @return  Returns the {@link MgEnvelope} object with extent of selection
 */
 public MgEnvelope getExtents(MgFeatureService featureService) {
    long cPtr = MapGuideJavaApiExJNI.MgSelectionBase_GetExtents(swigCPtr, MgFeatureService.getCPtr(featureService));
    return (cPtr == 0) ? null : (MgEnvelope)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Adds the given feature (represented by its base64 encoded id)
 * to the selection set
 *
 * @param  layer (CREFSTRING)  Name of layer
 * @param  className (CREFSTRING)  Name of feature class
 * @param  id (CREFSTRING)  Base 64 string encoded ID of the feature
 */
 public void add(String layer, String className, String id) {
    MapGuideJavaApiExJNI.MgSelectionBase_Add(swigCPtr, layer, className, id);
  }

  
/**
 * Loads the map object from a session repository.
 *
 * @param  resourceService ({@link MgResourceService})  An {@link MgResourceService} that can be used to retrieve  the map.
 * @param  mapName (String/string)  A string that specifies the name of the map. This
 * @return  Returns nothing.
 */
 public void open(MgResourceService resourceService, String mapName) {
    MapGuideJavaApiExJNI.MgSelectionBase_Open(swigCPtr, MgResourceService.getCPtr(resourceService), mapName);
  }

  
/**
 * Save the map object to a session repository.
 *
 * @param  resourceService ({@link MgResourceService})  An {@link MgResourceService} that can be used to retrieve  the map.
 * @param  mapName (String/string)  A string that specifies the name of the map. This
 * @return  Returns nothing.
 */
 public void save(MgResourceService resourceService, String mapName) {
    MapGuideJavaApiExJNI.MgSelectionBase_Save(swigCPtr, MgResourceService.getCPtr(resourceService), mapName);
  }

  
/**
 * Builds a resource name based on the map name amd the session id
 *
 * @param  sessionId (String/string)  A string that specifies the session id
 * @param  mapName (String/string)  A string that specifies the name of the map. This
 * @return  Resource name.
 */
 public String getResourceName(String sessionId, String mapName) {
  { return MapGuideJavaApiExJNI.MgSelectionBase_GetResourceName(swigCPtr, sessionId, mapName); }
}

}
