/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Provides forward-only, read-only functionality for
 * enumerating spatial context information retrieved from a
 * feature source.
 *
 */
 public class MgSpatialContextReader extends MgSerializable {
  private long swigCPtr;

  public MgSpatialContextReader(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgSpatialContextReaderToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgSpatialContextReader() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgSpatialContextReader(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgSpatialContextReader obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the name of the spatial context currently being read.
 *
 * @return  Returns the name of the spatial context.
 */
 public String getName() {
  { return MapGuideJavaApiExJNI.MgSpatialContextReader_GetName(swigCPtr); }
}

  
/**
 * Gets the description of the spatial context currently being read.
 *
 * @return  Returns the description of the spatial context.
 */
 public String getDescription() {
  { return MapGuideJavaApiExJNI.MgSpatialContextReader_GetDescription(swigCPtr); }
}

  
/**
 * Gets the name of the coordinate system of the spatial context
 * currently being read. If the result is a null string, the
 * coordinate system is unknown to the spatial context.
 *
 * @return  Returns the coordinate system name or NULL if unknown.
 */
 public String getCoordinateSystem() {
  { return MapGuideJavaApiExJNI.MgSpatialContextReader_GetCoordinateSystem(swigCPtr); }
}

  
/**
 * Gets the name of the coordinate system currently being read
 * in well-known text format.
 *
 * @return  Returns the coordinate system name in OGC WKT format or NULL
 *  if unknown.
 */
 public String getCoordinateSystemWkt() {
  { return MapGuideJavaApiExJNI.MgSpatialContextReader_GetCoordinateSystemWkt(swigCPtr); }
}

  
/**
 * Gets the extent type of the spatial context currently being
 * read.
 *
 * @return  Returns the extent type as an {@link MgSpatialContextExtentType}
 *  value.
 */
 public int getExtentType() {
    return MapGuideJavaApiExJNI.MgSpatialContextReader_GetExtentType(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @return  Returns an {@link MgByteReader} object containing a geometry in AGF
 */
 public MgByteReader getExtent() {
    long cPtr = MapGuideJavaApiExJNI.MgSpatialContextReader_GetExtent(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @return  Returns the tolerance value.
 */
 public double getXYTolerance() {
    return MapGuideJavaApiExJNI.MgSpatialContextReader_GetXYTolerance(swigCPtr);
  }

  
/**
 * Gets the tolerance value for Z ordinates for the spatial
 * context currently being read.
 *
 * @return  Returns the tolerance value.
 */
 public double getZTolerance() {
    return MapGuideJavaApiExJNI.MgSpatialContextReader_GetZTolerance(swigCPtr);
  }

  
/**
 * Determines whether the spatial context currently being read
 * is the active spatial context.
 *
 * @return  Returns true if the current spatial context is the active
 *  one; otherwise returns false.
 */
@Deprecated
 public boolean isActive() {
    return MapGuideJavaApiExJNI.MgSpatialContextReader_IsActive(swigCPtr);
  }

  
/**
 * Advances the reader to the next spatial context.
 *
 * @return  Returns true if there is a next item; otherwise returns
 *  false.
 */
 public boolean readNext() {
    return MapGuideJavaApiExJNI.MgSpatialContextReader_ReadNext(swigCPtr);
  }

  
/**
 * Closes the SpatialContextReader object, freeing any resources
 * it may be holding.
 *
 * @return  Returns nothing.
 */
 public void close() {
    MapGuideJavaApiExJNI.MgSpatialContextReader_Close(swigCPtr);
  }

  
/**
 * Resets the SpatialContextReader object to the beginning just
 *
 * @return  Returns nothing.
 */
 public void reset() {
    MapGuideJavaApiExJNI.MgSpatialContextReader_Reset(swigCPtr);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Serializes the spatial context information to XML according
 *
 * @return  Returns an {@link MgByteReader} object containing the XML
 *  serialization of the spatial context information.
 */
 public MgByteReader toXml() {
    long cPtr = MapGuideJavaApiExJNI.MgSpatialContextReader_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
