/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This class provides services to render a map into an image
 *
 */
 public class MgTileService extends MgService {
  private long swigCPtr;

  public MgTileService(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgTileServiceToMgService(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgTileService() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgTileService(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgTileService obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Returns the specified base map tile for the given map.  If a cached tile
 * image exists it will return it, otherwise the tile is rendered and added
 * to the cache.
 *
 * @param  map  Input  Map object containing current state of map.
 * @param  baseMapLayerGroupName  Input  Specifies the name of the baseMapLayerGroup for which to render the tile.
 * @param  tileColumn  Input  Specifies the column index of the tile to return.
 * @param  tileRow  Input  Specifies the row index of the tile to return.
 * @return  A byte reader containing the rendered tile image.
 */
 public MgByteReader getTile(MgMap map, String baseMapLayerGroupName, int tileColumn, int tileRow) {
    long cPtr = MapGuideJavaApiExJNI.MgTileService_GetTile__SWIG_0(swigCPtr, MgMap.getCPtr(map), baseMapLayerGroupName, tileColumn, tileRow);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the specified base map tile for the given map or tile set.
 * If a cached tile image exists it will return it, otherwise the tile
 * is rendered and added to the cache.
 *
 * @param  resource  Input  Resource identifier for the map definition or Tile Set Definition
 * @param  baseMapLayerGroupName  Input  Specifies the name of the baseMapLayerGroup for which to render the tile.
 * @param  tileColumn  Input  Specifies the column index of the tile to return.
 * @param  tileRow  Input  Specifies the row index of the tile to return.
 * @param  scaleIndex  Input  Scale index to render.  Most detailed scale is index 0.
 * @return  A byte reader containing the rendered tile image.
 */
 public MgByteReader getTile(MgResourceIdentifier resource, String baseMapLayerGroupName, int tileColumn, int tileRow, int scaleIndex) {
    long cPtr = MapGuideJavaApiExJNI.MgTileService_GetTile__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(resource), baseMapLayerGroupName, tileColumn, tileRow, scaleIndex);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Clears the entire tile cache for the given map.  Tiles for all base
 * map layer groups and finite scales will be removed.
 *
 * @param  map  Input  Specifies the map whose tile cache will be cleared.
 */
 public void clearCache(MgMap map) {
    MapGuideJavaApiExJNI.MgTileService_ClearCache__SWIG_0(swigCPtr, MgMap.getCPtr(map));
  }

  
/**
 * Clears the entire tile cache for the given tile set.  Tiles for all base
 * map layer groups and finite scales will be removed.
 *
 * @param  map  Input  Specifies the map whose tile cache will be cleared.
 * @since  3.0 */
 public void clearCache(MgResourceIdentifier tileSet) {
    MapGuideJavaApiExJNI.MgTileService_ClearCache__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(tileSet));
  }

  
/**
 * Returns the default width of a tile.
 *
 * @return  Default width of a tile in pixels.
 * @since  1.2 */
 public int getDefaultTileSizeX() {
    return MapGuideJavaApiExJNI.MgTileService_GetDefaultTileSizeX__SWIG_0(swigCPtr);
  }

  
/**
 * Returns the default height of a tile.
 *
 * @return  Default height of a tile in pixels.
 * @since  1.2 */
 public int getDefaultTileSizeY() {
    return MapGuideJavaApiExJNI.MgTileService_GetDefaultTileSizeY__SWIG_0(swigCPtr);
  }

  
/**
 * Returns the default width of a tile.
 *
 * @param  tileSet  Input  Specifies the resource id of the tile set
 * @return  Default width of a tile in pixels.
 * @since  3.0 */
 public int getDefaultTileSizeX(MgResourceIdentifier tileSet) {
    return MapGuideJavaApiExJNI.MgTileService_GetDefaultTileSizeX__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(tileSet));
  }

  
/**
 * Returns the default height of a tile.
 *
 * @param  tileSet  Input  Specifies the resource id of the tile set
 * @return  Default height of a tile in pixels.
 * @since  3.0 */
 public int getDefaultTileSizeY(MgResourceIdentifier tileSet) {
    return MapGuideJavaApiExJNI.MgTileService_GetDefaultTileSizeY__SWIG_1(swigCPtr, MgResourceIdentifier.getCPtr(tileSet));
  }

  
/**
 * Returns the XML description of available tile providers, along with supported connection parameters. This provides
 * sufficient information for client applications to build rich editor user interfaces for editing Tile Set Definitions
 *
 * @return  The XML description of available tile providers
 * @since  3.0 */
 public MgByteReader getTileProviders() {
    long cPtr = MapGuideJavaApiExJNI.MgTileService_GetTileProviders(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
