/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Translates a string in AGF (Autodesk Geometry Format) Text
 *
 */
 public class MgWktReaderWriter extends MgGuardDisposable {
  private long swigCPtr;

  public MgWktReaderWriter(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgWktReaderWriterToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgWktReaderWriter(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgWktReaderWriter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructor
 *
 */
 public MgWktReaderWriter() {
    this(MapGuideJavaApiExJNI.new_MgWktReaderWriter(), true);
  }

  
/**
 * Reads a geometry object from an AGF Text format.
 *
 * @param  wkt (String/string)  A string that supplies the AGF Text  representation.
 * @return  An instance of {@link MgGeometry} that corresponds to the specified
 *  AGF Text.
 */
 public MgGeometry read(String wkt) {
    long cPtr = MapGuideJavaApiExJNI.MgWktReaderWriter_Read__SWIG_0(swigCPtr, wkt);
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Reads a geometry object from a string in WKT format applying
 * the specified transform during the read.
 *
 * @param  wkt (String/string)  A string that supplies the WKT representation.
 * @param  transform ({@link MgTransform})  An {@link MgTransform} that is used to transform each coordinate read from the  WKT representation.
 * @return  An instance of {@link MgGeometry} that corresponds to the specified WKT with
 *  the specified transform applied.
 */
 public MgGeometry read(String wkt, MgTransform transform) {
    long cPtr = MapGuideJavaApiExJNI.MgWktReaderWriter_Read__SWIG_1(swigCPtr, wkt, MgTransform.getCPtr(transform));
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Writes a geometry object to a string in AGF Text format.
 *
 * @param  geometry ({@link MgGeometry})  An {@link MgGeometry} object to write to AGF Text.
 * @return  A string that contains the AGF Text representation.
 */
 public String write(MgGeometry geometry) {
  { return MapGuideJavaApiExJNI.MgWktReaderWriter_Write__SWIG_0(swigCPtr, MgGeometry.getCPtr(geometry)); }
}

  
/**
 * Writes a geometry object to a string in WKT format applying
 * the specified transform during the write.
 *
 * @param  geometry ({@link MgGeometry})  An {@link MgGeometry} object to write to WKT.
 * @param  transform ({@link MgTransform})  An {@link MgTransform} that is used to transform each coordinate written to the  WKT representation.
 * @return  A string that contains the transformed WKT representation.
 */
 public String write(MgGeometry geometry, MgTransform transform) {
  { return MapGuideJavaApiExJNI.MgWktReaderWriter_Write__SWIG_1(swigCPtr, MgGeometry.getCPtr(geometry), MgTransform.getCPtr(transform)); }
}

}
