package org.osgeo.mapguide;

import java.util.*;
import java.lang.reflect.*;

public class ObjectFactory
{
public static Object createObject(int id, long cptr, boolean ownCptr)
{
	Constructor ctor = (Constructor)classMap.get(new Integer(id));
	if(ctor == null)
		return null;
	try
	{
		return ctor.newInstance(new Object[] { new Long(cptr), new Boolean(ownCptr) });
	}
	catch(Exception e)
	{
		e.printStackTrace();
		return null;
	}
}


protected static Hashtable classMap;

static
{
	classMap = new Hashtable();
	try
	{
		classMap.put(new Integer(20004), Class.forName("org.osgeo.mapguide.MgAgfReaderWriter").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20005), Class.forName("org.osgeo.mapguide.MgAggregateGeometry").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1500), Class.forName("org.osgeo.mapguide.MgApplicationException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20006), Class.forName("org.osgeo.mapguide.MgArcSegment").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1501), Class.forName("org.osgeo.mapguide.MgArgumentOutOfRangeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10500), Class.forName("org.osgeo.mapguide.MgArrayTypeMismatchException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30000), Class.forName("org.osgeo.mapguide.MgAuthenticationFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1005), Class.forName("org.osgeo.mapguide.MgBatchPropertyCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10252), Class.forName("org.osgeo.mapguide.MgBlobProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10253), Class.forName("org.osgeo.mapguide.MgBooleanProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10254), Class.forName("org.osgeo.mapguide.MgByteProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1250), Class.forName("org.osgeo.mapguide.MgByteReader").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1257), Class.forName("org.osgeo.mapguide.MgByteSink").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1251), Class.forName("org.osgeo.mapguide.MgByteSource").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11750), Class.forName("org.osgeo.mapguide.MgClassDefinition").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11780), Class.forName("org.osgeo.mapguide.MgClassDefinitionCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1502), Class.forName("org.osgeo.mapguide.MgClassNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10255), Class.forName("org.osgeo.mapguide.MgClobProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10250), Class.forName("org.osgeo.mapguide.MgColor").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1503), Class.forName("org.osgeo.mapguide.MgConfigurationException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1504), Class.forName("org.osgeo.mapguide.MgConfigurationLoadFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1505), Class.forName("org.osgeo.mapguide.MgConfigurationSaveFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30001), Class.forName("org.osgeo.mapguide.MgConnectionFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30002), Class.forName("org.osgeo.mapguide.MgConnectionNotOpenException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20003), Class.forName("org.osgeo.mapguide.MgCoordinate").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20009), Class.forName("org.osgeo.mapguide.MgCoordinateIterator").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20500), Class.forName("org.osgeo.mapguide.MgCoordinateSystem").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20504), Class.forName("org.osgeo.mapguide.MgCoordinateSystemCatalog").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20506), Class.forName("org.osgeo.mapguide.MgCoordinateSystemCategory").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20510), Class.forName("org.osgeo.mapguide.MgCoordinateSystemCategoryDictionary").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21000), Class.forName("org.osgeo.mapguide.MgCoordinateSystemComputationFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21001), Class.forName("org.osgeo.mapguide.MgCoordinateSystemConversionFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20507), Class.forName("org.osgeo.mapguide.MgCoordinateSystemDatum").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20512), Class.forName("org.osgeo.mapguide.MgCoordinateSystemDatumDictionary").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20511), Class.forName("org.osgeo.mapguide.MgCoordinateSystemDictionary").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20521), Class.forName("org.osgeo.mapguide.MgCoordinateSystemDictionaryUtility").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20509), Class.forName("org.osgeo.mapguide.MgCoordinateSystemEllipsoid").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20513), Class.forName("org.osgeo.mapguide.MgCoordinateSystemEllipsoidDictionary").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20514), Class.forName("org.osgeo.mapguide.MgCoordinateSystemEnum").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20515), Class.forName("org.osgeo.mapguide.MgCoordinateSystemEnumInteger32").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20501), Class.forName("org.osgeo.mapguide.MgCoordinateSystemFactory").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20516), Class.forName("org.osgeo.mapguide.MgCoordinateSystemFilter").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20517), Class.forName("org.osgeo.mapguide.MgCoordinateSystemFilterInteger32").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20505), Class.forName("org.osgeo.mapguide.MgCoordinateSystemFormatConverter").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20542), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticAnalyticalTransformDefParams").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20543), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticInterpolationTransformDefParams").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20544), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticMultipleRegressionTransformDefParams").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20533), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticPath").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20535), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticPathDictionary").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20534), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticPathElement").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20536), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticTransformDef").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20540), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticTransformDefDictionary").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20545), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticTransformGridFile").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20508), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGeodeticTransformation").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20532), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGridBase").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20524), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGridBoundary").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20529), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGridLine").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20526), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGridLineCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20530), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGridRegion").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20527), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGridRegionCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20525), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGridSpecification").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20531), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGridTick").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20528), Class.forName("org.osgeo.mapguide.MgCoordinateSystemGridTickCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21002), Class.forName("org.osgeo.mapguide.MgCoordinateSystemInitializationFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21003), Class.forName("org.osgeo.mapguide.MgCoordinateSystemLoadFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20518), Class.forName("org.osgeo.mapguide.MgCoordinateSystemMathComparator").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20502), Class.forName("org.osgeo.mapguide.MgCoordinateSystemMeasure").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21004), Class.forName("org.osgeo.mapguide.MgCoordinateSystemMeasureFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20522), Class.forName("org.osgeo.mapguide.MgCoordinateSystemMgrs").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20520), Class.forName("org.osgeo.mapguide.MgCoordinateSystemProjectionInformation").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20503), Class.forName("org.osgeo.mapguide.MgCoordinateSystemTransform").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21005), Class.forName("org.osgeo.mapguide.MgCoordinateSystemTransformFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20519), Class.forName("org.osgeo.mapguide.MgCoordinateSystemUnitInformation").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20048), Class.forName("org.osgeo.mapguide.MgCoordinateXY").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20051), Class.forName("org.osgeo.mapguide.MgCoordinateXYM").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20049), Class.forName("org.osgeo.mapguide.MgCoordinateXYZ").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20050), Class.forName("org.osgeo.mapguide.MgCoordinateXYZM").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20010), Class.forName("org.osgeo.mapguide.MgCurve").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20011), Class.forName("org.osgeo.mapguide.MgCurvePolygon").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20047), Class.forName("org.osgeo.mapguide.MgCurvePolygonCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20012), Class.forName("org.osgeo.mapguide.MgCurveRing").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20052), Class.forName("org.osgeo.mapguide.MgCurveRingCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20013), Class.forName("org.osgeo.mapguide.MgCurveSegment").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20041), Class.forName("org.osgeo.mapguide.MgCurveSegmentCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20014), Class.forName("org.osgeo.mapguide.MgCurveString").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20043), Class.forName("org.osgeo.mapguide.MgCurveStringCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11751), Class.forName("org.osgeo.mapguide.MgDataPropertyDefinition").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11773), Class.forName("org.osgeo.mapguide.MgDataReader").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1256), Class.forName("org.osgeo.mapguide.MgDateTime").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1506), Class.forName("org.osgeo.mapguide.MgDateTimeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10256), Class.forName("org.osgeo.mapguide.MgDateTimeProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30003), Class.forName("org.osgeo.mapguide.MgDbException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30004), Class.forName("org.osgeo.mapguide.MgDbXmlException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1507), Class.forName("org.osgeo.mapguide.MgDecryptionException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11775), Class.forName("org.osgeo.mapguide.MgDeleteFeatures").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1508), Class.forName("org.osgeo.mapguide.MgDirectoryNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1000), Class.forName("org.osgeo.mapguide.MgDisposableCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1509), Class.forName("org.osgeo.mapguide.MgDivideByZeroException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1510), Class.forName("org.osgeo.mapguide.MgDomainException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10257), Class.forName("org.osgeo.mapguide.MgDoubleProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30700), Class.forName("org.osgeo.mapguide.MgDrawingService").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1511), Class.forName("org.osgeo.mapguide.MgDuplicateDirectoryException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1512), Class.forName("org.osgeo.mapguide.MgDuplicateFileException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30005), Class.forName("org.osgeo.mapguide.MgDuplicateGroupException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30006), Class.forName("org.osgeo.mapguide.MgDuplicateNameException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1513), Class.forName("org.osgeo.mapguide.MgDuplicateObjectException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30007), Class.forName("org.osgeo.mapguide.MgDuplicateParameterException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30008), Class.forName("org.osgeo.mapguide.MgDuplicateRepositoryException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10501), Class.forName("org.osgeo.mapguide.MgDuplicateResourceDataException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10502), Class.forName("org.osgeo.mapguide.MgDuplicateResourceException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30009), Class.forName("org.osgeo.mapguide.MgDuplicateRoleException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30010), Class.forName("org.osgeo.mapguide.MgDuplicateServerException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30011), Class.forName("org.osgeo.mapguide.MgDuplicateSessionException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30012), Class.forName("org.osgeo.mapguide.MgDuplicateUserException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30013), Class.forName("org.osgeo.mapguide.MgDwfException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30014), Class.forName("org.osgeo.mapguide.MgDwfSectionNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30015), Class.forName("org.osgeo.mapguide.MgDwfSectionResourceNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30901), Class.forName("org.osgeo.mapguide.MgDwfVersion").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10503), Class.forName("org.osgeo.mapguide.MgEmptyFeatureSetException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1514), Class.forName("org.osgeo.mapguide.MgEncryptionException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30016), Class.forName("org.osgeo.mapguide.MgEndOfStreamException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20001), Class.forName("org.osgeo.mapguide.MgEnvelope").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1515), Class.forName("org.osgeo.mapguide.MgException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10504), Class.forName("org.osgeo.mapguide.MgFdoException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11772), Class.forName("org.osgeo.mapguide.MgFeatureAggregateOptions").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11774), Class.forName("org.osgeo.mapguide.MgFeatureCommandCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(31001), Class.forName("org.osgeo.mapguide.MgFeatureInformation").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11764), Class.forName("org.osgeo.mapguide.MgFeatureProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11771), Class.forName("org.osgeo.mapguide.MgFeatureQueryOptions").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11753), Class.forName("org.osgeo.mapguide.MgFeatureReader").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11778), Class.forName("org.osgeo.mapguide.MgFeatureSchema").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11779), Class.forName("org.osgeo.mapguide.MgFeatureSchemaCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11754), Class.forName("org.osgeo.mapguide.MgFeatureService").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10505), Class.forName("org.osgeo.mapguide.MgFeatureServiceException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11786), Class.forName("org.osgeo.mapguide.MgFileFeatureSourceParams").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1516), Class.forName("org.osgeo.mapguide.MgFileIoException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1517), Class.forName("org.osgeo.mapguide.MgFileNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20016), Class.forName("org.osgeo.mapguide.MgGeometricEntity").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11756), Class.forName("org.osgeo.mapguide.MgGeometricPropertyDefinition").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20019), Class.forName("org.osgeo.mapguide.MgGeometry").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20020), Class.forName("org.osgeo.mapguide.MgGeometryCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20021), Class.forName("org.osgeo.mapguide.MgGeometryComponent").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21006), Class.forName("org.osgeo.mapguide.MgGeometryException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20002), Class.forName("org.osgeo.mapguide.MgGeometryFactory").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11758), Class.forName("org.osgeo.mapguide.MgGeometryProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11785), Class.forName("org.osgeo.mapguide.MgGeometryTypeInfo").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30018), Class.forName("org.osgeo.mapguide.MgGroupNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11782), Class.forName("org.osgeo.mapguide.MgGwsFeatureReader").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(40000), Class.forName("org.osgeo.mapguide.MgHttpHeader").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(40006), Class.forName("org.osgeo.mapguide.MgHttpPrimitiveValue").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(40004), Class.forName("org.osgeo.mapguide.MgHttpRequest").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(40002), Class.forName("org.osgeo.mapguide.MgHttpRequestMetadata").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(40001), Class.forName("org.osgeo.mapguide.MgHttpRequestParam").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(40005), Class.forName("org.osgeo.mapguide.MgHttpResponse").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(40003), Class.forName("org.osgeo.mapguide.MgHttpResult").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1518), Class.forName("org.osgeo.mapguide.MgIndexOutOfRangeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11776), Class.forName("org.osgeo.mapguide.MgInsertFeatures").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10258), Class.forName("org.osgeo.mapguide.MgInt16Property").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10259), Class.forName("org.osgeo.mapguide.MgInt32Property").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10260), Class.forName("org.osgeo.mapguide.MgInt64Property").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10000), Class.forName("org.osgeo.mapguide.MgIntCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1519), Class.forName("org.osgeo.mapguide.MgInvalidArgumentException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1520), Class.forName("org.osgeo.mapguide.MgInvalidCastException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21007), Class.forName("org.osgeo.mapguide.MgInvalidCoordinateSystemException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21008), Class.forName("org.osgeo.mapguide.MgInvalidCoordinateSystemTypeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(21009), Class.forName("org.osgeo.mapguide.MgInvalidCoordinateSystemUnitsException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30019), Class.forName("org.osgeo.mapguide.MgInvalidDwfPackageException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30020), Class.forName("org.osgeo.mapguide.MgInvalidDwfSectionException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30021), Class.forName("org.osgeo.mapguide.MgInvalidFeatureSourceException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30022), Class.forName("org.osgeo.mapguide.MgInvalidIpAddressException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30023), Class.forName("org.osgeo.mapguide.MgInvalidLicenseException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30024), Class.forName("org.osgeo.mapguide.MgInvalidLogEntryException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10507), Class.forName("org.osgeo.mapguide.MgInvalidMapDefinitionException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1522), Class.forName("org.osgeo.mapguide.MgInvalidOperationException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30026), Class.forName("org.osgeo.mapguide.MgInvalidPasswordException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30027), Class.forName("org.osgeo.mapguide.MgInvalidPrintLayoutFontSizeUnitsException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30028), Class.forName("org.osgeo.mapguide.MgInvalidPrintLayoutPositionUnitsException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30029), Class.forName("org.osgeo.mapguide.MgInvalidPrintLayoutSizeUnitsException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1523), Class.forName("org.osgeo.mapguide.MgInvalidPropertyTypeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10508), Class.forName("org.osgeo.mapguide.MgInvalidRepositoryNameException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10509), Class.forName("org.osgeo.mapguide.MgInvalidRepositoryTypeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10510), Class.forName("org.osgeo.mapguide.MgInvalidResourceDataNameException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10511), Class.forName("org.osgeo.mapguide.MgInvalidResourceDataTypeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10512), Class.forName("org.osgeo.mapguide.MgInvalidResourceNameException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10513), Class.forName("org.osgeo.mapguide.MgInvalidResourcePathException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10514), Class.forName("org.osgeo.mapguide.MgInvalidResourcePreProcessingTypeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10515), Class.forName("org.osgeo.mapguide.MgInvalidResourceTypeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30031), Class.forName("org.osgeo.mapguide.MgInvalidServerNameException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1524), Class.forName("org.osgeo.mapguide.MgInvalidStreamHeaderException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1525), Class.forName("org.osgeo.mapguide.MgIoException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(31300), Class.forName("org.osgeo.mapguide.MgKmlService").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30501), Class.forName("org.osgeo.mapguide.MgLayer").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(12003), Class.forName("org.osgeo.mapguide.MgLayerBase").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(12002), Class.forName("org.osgeo.mapguide.MgLayerCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(12001), Class.forName("org.osgeo.mapguide.MgLayerGroup").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(12004), Class.forName("org.osgeo.mapguide.MgLayerGroupCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10517), Class.forName("org.osgeo.mapguide.MgLayerNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30904), Class.forName("org.osgeo.mapguide.MgLayout").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1526), Class.forName("org.osgeo.mapguide.MgLengthException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30032), Class.forName("org.osgeo.mapguide.MgLicenseException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30033), Class.forName("org.osgeo.mapguide.MgLicenseExpiredException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20042), Class.forName("org.osgeo.mapguide.MgLineString").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20044), Class.forName("org.osgeo.mapguide.MgLineStringCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20023), Class.forName("org.osgeo.mapguide.MgLinearRing").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20053), Class.forName("org.osgeo.mapguide.MgLinearRingCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20024), Class.forName("org.osgeo.mapguide.MgLinearSegment").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1527), Class.forName("org.osgeo.mapguide.MgLogicException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11766), Class.forName("org.osgeo.mapguide.MgLongTransactionReader").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30500), Class.forName("org.osgeo.mapguide.MgMap").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(12000), Class.forName("org.osgeo.mapguide.MgMapBase").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(12005), Class.forName("org.osgeo.mapguide.MgMapCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30905), Class.forName("org.osgeo.mapguide.MgMapPlot").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30906), Class.forName("org.osgeo.mapguide.MgMapPlotCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30900), Class.forName("org.osgeo.mapguide.MgMappingService").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20029), Class.forName("org.osgeo.mapguide.MgMultiCurvePolygon").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20030), Class.forName("org.osgeo.mapguide.MgMultiCurveString").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20031), Class.forName("org.osgeo.mapguide.MgMultiGeometry").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20032), Class.forName("org.osgeo.mapguide.MgMultiLineString").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20033), Class.forName("org.osgeo.mapguide.MgMultiPoint").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20034), Class.forName("org.osgeo.mapguide.MgMultiPolygon").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1528), Class.forName("org.osgeo.mapguide.MgNotFiniteNumberException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1529), Class.forName("org.osgeo.mapguide.MgNotImplementedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1530), Class.forName("org.osgeo.mapguide.MgNullArgumentException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1531), Class.forName("org.osgeo.mapguide.MgNullPropertyValueException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1532), Class.forName("org.osgeo.mapguide.MgNullReferenceException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1533), Class.forName("org.osgeo.mapguide.MgObjectNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11759), Class.forName("org.osgeo.mapguide.MgObjectPropertyDefinition").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30035), Class.forName("org.osgeo.mapguide.MgOperationProcessingException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1534), Class.forName("org.osgeo.mapguide.MgOutOfMemoryException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1535), Class.forName("org.osgeo.mapguide.MgOutOfRangeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1536), Class.forName("org.osgeo.mapguide.MgOverflowException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30604), Class.forName("org.osgeo.mapguide.MgPackageStatusInformation").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11788), Class.forName("org.osgeo.mapguide.MgParameter").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10004), Class.forName("org.osgeo.mapguide.MgParameterCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30036), Class.forName("org.osgeo.mapguide.MgParameterNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30037), Class.forName("org.osgeo.mapguide.MgPathTooLongException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1537), Class.forName("org.osgeo.mapguide.MgPlatformNotSupportedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30902), Class.forName("org.osgeo.mapguide.MgPlotSpecification").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20000), Class.forName("org.osgeo.mapguide.MgPoint").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20045), Class.forName("org.osgeo.mapguide.MgPointCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20035), Class.forName("org.osgeo.mapguide.MgPolygon").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20046), Class.forName("org.osgeo.mapguide.MgPolygonCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30039), Class.forName("org.osgeo.mapguide.MgPortNotAvailableException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30040), Class.forName("org.osgeo.mapguide.MgPrintToScaleModeNotSelectedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(31400), Class.forName("org.osgeo.mapguide.MgProfilingService").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(2000), Class.forName("org.osgeo.mapguide.MgProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1002), Class.forName("org.osgeo.mapguide.MgPropertyCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(2002), Class.forName("org.osgeo.mapguide.MgPropertyDefinition").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10001), Class.forName("org.osgeo.mapguide.MgPropertyDefinitionCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11769), Class.forName("org.osgeo.mapguide.MgRaster").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11770), Class.forName("org.osgeo.mapguide.MgRasterProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11768), Class.forName("org.osgeo.mapguide.MgRasterPropertyDefinition").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(12006), Class.forName("org.osgeo.mapguide.MgReadOnlyLayerCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20037), Class.forName("org.osgeo.mapguide.MgRegion").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(31002), Class.forName("org.osgeo.mapguide.MgRenderingOptions").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(31000), Class.forName("org.osgeo.mapguide.MgRenderingService").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30041), Class.forName("org.osgeo.mapguide.MgRepositoryCreationFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30042), Class.forName("org.osgeo.mapguide.MgRepositoryNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30043), Class.forName("org.osgeo.mapguide.MgRepositoryNotOpenException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30044), Class.forName("org.osgeo.mapguide.MgRepositoryOpenFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11526), Class.forName("org.osgeo.mapguide.MgResource").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10518), Class.forName("org.osgeo.mapguide.MgResourceBusyException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10519), Class.forName("org.osgeo.mapguide.MgResourceDataNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11500), Class.forName("org.osgeo.mapguide.MgResourceIdentifier").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10520), Class.forName("org.osgeo.mapguide.MgResourceNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11501), Class.forName("org.osgeo.mapguide.MgResourceService").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1540), Class.forName("org.osgeo.mapguide.MgResourceTagNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1538), Class.forName("org.osgeo.mapguide.MgResourcesException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1539), Class.forName("org.osgeo.mapguide.MgResourcesLoadFailedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20038), Class.forName("org.osgeo.mapguide.MgRing").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30045), Class.forName("org.osgeo.mapguide.MgRoleNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1541), Class.forName("org.osgeo.mapguide.MgRuntimeException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30502), Class.forName("org.osgeo.mapguide.MgSelection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(12007), Class.forName("org.osgeo.mapguide.MgSelectionBase").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30607), Class.forName("org.osgeo.mapguide.MgServerAdmin").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30046), Class.forName("org.osgeo.mapguide.MgServerNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30047), Class.forName("org.osgeo.mapguide.MgServerNotOnlineException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11251), Class.forName("org.osgeo.mapguide.MgService").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10521), Class.forName("org.osgeo.mapguide.MgServiceNotAvailableException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10522), Class.forName("org.osgeo.mapguide.MgServiceNotSupportedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30048), Class.forName("org.osgeo.mapguide.MgSessionExpiredException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30052), Class.forName("org.osgeo.mapguide.MgSessionNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10261), Class.forName("org.osgeo.mapguide.MgSingleProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30605), Class.forName("org.osgeo.mapguide.MgSite").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30601), Class.forName("org.osgeo.mapguide.MgSiteConnection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30608), Class.forName("org.osgeo.mapguide.MgSiteInfo").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11761), Class.forName("org.osgeo.mapguide.MgSpatialContextReader").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11762), Class.forName("org.osgeo.mapguide.MgSqlDataReader").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1542), Class.forName("org.osgeo.mapguide.MgStreamIoException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1003), Class.forName("org.osgeo.mapguide.MgStringCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(2001), Class.forName("org.osgeo.mapguide.MgStringProperty").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10003), Class.forName("org.osgeo.mapguide.MgStringPropertyCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1543), Class.forName("org.osgeo.mapguide.MgSystemException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1544), Class.forName("org.osgeo.mapguide.MgTemporaryFileNotAvailableException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1545), Class.forName("org.osgeo.mapguide.MgThirdPartyException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(31200), Class.forName("org.osgeo.mapguide.MgTileService").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11787), Class.forName("org.osgeo.mapguide.MgTransaction").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30049), Class.forName("org.osgeo.mapguide.MgUnauthorizedAccessException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1547), Class.forName("org.osgeo.mapguide.MgUnclassifiedException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1548), Class.forName("org.osgeo.mapguide.MgUnderflowException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30056), Class.forName("org.osgeo.mapguide.MgUnknownTileProviderException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30057), Class.forName("org.osgeo.mapguide.MgUnsupportedTileProviderException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11777), Class.forName("org.osgeo.mapguide.MgUpdateFeatures").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30050), Class.forName("org.osgeo.mapguide.MgUriFormatException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(30606), Class.forName("org.osgeo.mapguide.MgUserInformation").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(10523), Class.forName("org.osgeo.mapguide.MgUserNotFoundException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(11257), Class.forName("org.osgeo.mapguide.MgWarnings").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50005), Class.forName("org.osgeo.mapguide.MgWebBufferCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50000), Class.forName("org.osgeo.mapguide.MgWebCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50012), Class.forName("org.osgeo.mapguide.MgWebCommandCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50015), Class.forName("org.osgeo.mapguide.MgWebCommandWidget").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50025), Class.forName("org.osgeo.mapguide.MgWebContextMenu").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50016), Class.forName("org.osgeo.mapguide.MgWebFlyoutWidget").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50009), Class.forName("org.osgeo.mapguide.MgWebGetPrintablePageCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50011), Class.forName("org.osgeo.mapguide.MgWebHelpCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50022), Class.forName("org.osgeo.mapguide.MgWebInformationPane").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50003), Class.forName("org.osgeo.mapguide.MgWebInvokeScriptCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50004), Class.forName("org.osgeo.mapguide.MgWebInvokeUrlCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50026), Class.forName("org.osgeo.mapguide.MgWebLayout").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50008), Class.forName("org.osgeo.mapguide.MgWebMeasureCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50007), Class.forName("org.osgeo.mapguide.MgWebPrintCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50002), Class.forName("org.osgeo.mapguide.MgWebSearchCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50006), Class.forName("org.osgeo.mapguide.MgWebSelectWithinCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50014), Class.forName("org.osgeo.mapguide.MgWebSeparatorWidget").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50023), Class.forName("org.osgeo.mapguide.MgWebTaskBar").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50017), Class.forName("org.osgeo.mapguide.MgWebTaskBarWidget").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50024), Class.forName("org.osgeo.mapguide.MgWebTaskPane").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50021), Class.forName("org.osgeo.mapguide.MgWebToolBar").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50019), Class.forName("org.osgeo.mapguide.MgWebUiPane").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50020), Class.forName("org.osgeo.mapguide.MgWebUiSizablePane").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50001), Class.forName("org.osgeo.mapguide.MgWebUiTargetCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50010), Class.forName("org.osgeo.mapguide.MgWebViewOptionsCommand").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50013), Class.forName("org.osgeo.mapguide.MgWebWidget").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(50018), Class.forName("org.osgeo.mapguide.MgWebWidgetCollection").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(20040), Class.forName("org.osgeo.mapguide.MgWktReaderWriter").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1549), Class.forName("org.osgeo.mapguide.MgXmlException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
		classMap.put(new Integer(1550), Class.forName("org.osgeo.mapguide.MgXmlParserException").getConstructor(new Class[] { Long.TYPE, Boolean.TYPE }));
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
}
}
