/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.mapguide;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.osgeo.mapguide.MapGuideJavaApiExJNI;
import org.osgeo.mapguide.MgGuardDisposable;
import org.osgeo.mapguide.MgLayerBase;
import org.osgeo.mapguide.ObjectFactory;

public class MgReadOnlyLayerCollection
extends MgGuardDisposable
implements Iterable<MgLayerBase> {
    private long swigCPtr;

    public MgReadOnlyLayerCollection(long l, boolean bl) {
        super(MapGuideJavaApiExJNI.SWIGMgReadOnlyLayerCollectionToMgGuardDisposable(l), bl);
        this.swigCPtr = l;
    }

    protected MgReadOnlyLayerCollection() {
        this(0L, false);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            MapGuideJavaApiExJNI.delete_MgReadOnlyLayerCollection(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    protected static long getCPtr(MgReadOnlyLayerCollection mgReadOnlyLayerCollection) {
        return mgReadOnlyLayerCollection == null ? 0L : mgReadOnlyLayerCollection.swigCPtr;
    }

    @Override
    public Iterator<MgLayerBase> iterator() {
        return new ItemIterator(this);
    }

    public int getCount() {
        return MapGuideJavaApiExJNI.MgReadOnlyLayerCollection_GetCount(this.swigCPtr);
    }

    public MgLayerBase getItem(int n) {
        long l = MapGuideJavaApiExJNI.MgReadOnlyLayerCollection_GetItem(this.swigCPtr, n);
        return l == 0L ? null : (MgLayerBase)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(l), l, true);
    }

    public boolean contains(MgLayerBase mgLayerBase) {
        return MapGuideJavaApiExJNI.MgReadOnlyLayerCollection_Contains(this.swigCPtr, MgLayerBase.getCPtr(mgLayerBase));
    }

    public int indexOf(MgLayerBase mgLayerBase) {
        return MapGuideJavaApiExJNI.MgReadOnlyLayerCollection_IndexOf(this.swigCPtr, MgLayerBase.getCPtr(mgLayerBase));
    }

    class ItemIterator
    implements Iterator<MgLayerBase> {
        private MgReadOnlyLayerCollection _collection;
        private int _pos;
        private int _count;

        public ItemIterator(MgReadOnlyLayerCollection mgReadOnlyLayerCollection2) {
            this._collection = mgReadOnlyLayerCollection2;
            this._count = this._collection.getCount();
            this._pos = -1;
        }

        @Override
        public boolean hasNext() {
            return this._pos + 1 < this._count;
        }

        @Override
        public MgLayerBase next() {
            ++this._pos;
            if (this._pos >= this._count) {
                throw new NoSuchElementException();
            }
            return this._collection.getItem(this._pos);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

