/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.mapguide;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.osgeo.mapguide.MapGuideJavaApiExJNI;
import org.osgeo.mapguide.MgByteReader;
import org.osgeo.mapguide.MgCollection;
import org.osgeo.mapguide.ObjectFactory;

public class MgStringCollection
extends MgCollection
implements Collection<String> {
    private long swigCPtr;

    public MgStringCollection(long l, boolean bl) {
        super(MapGuideJavaApiExJNI.SWIGMgStringCollectionToMgCollection(l), bl);
        this.swigCPtr = l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            MapGuideJavaApiExJNI.delete_MgStringCollection(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    protected static long getCPtr(MgStringCollection mgStringCollection) {
        return mgStringCollection == null ? 0L : mgStringCollection.swigCPtr;
    }

    @Override
    public Iterator<String> iterator() {
        return new ItemIterator(this);
    }

    @Override
    public boolean add(String string) {
        this.addItem(string);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        int n = 0;
        for (String string : collection) {
            this.addItem(string);
            ++n;
        }
        return n > 0;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof String) {
            return this.contains((String)object);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof String) {
            return this.remove((String)object);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int n = 0;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            ++n;
        }
        return n > 0;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getCount(); ++i) {
            String string = this.getItem(i);
            if (collection.contains(string)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            return this.removeAll(arrayList);
        }
        return false;
    }

    @Override
    public int size() {
        return this.getCount();
    }

    @Override
    public Object[] toArray() {
        int n = this.getCount();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getItem(i);
        }
        return objectArray;
    }

    @Override
    public <String> String[] toArray(String[] StringArray) {
        Object[] objectArray = this.toArray();
        if (StringArray.length >= objectArray.length) {
            int n;
            for (n = 0; n < objectArray.length; ++n) {
                StringArray[n] = objectArray[n];
            }
            for (n = objectArray.length; n < StringArray.length; ++n) {
                StringArray[n] = null;
            }
            return StringArray;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(StringArray.getClass().getComponentType(), objectArray.length);
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        return objectArray2;
    }

    public MgStringCollection() {
        this(MapGuideJavaApiExJNI.new_MgStringCollection(), true);
    }

    @Override
    public int getCount() {
        return MapGuideJavaApiExJNI.MgStringCollection_GetCount(this.swigCPtr);
    }

    public String getItem(int n) {
        return MapGuideJavaApiExJNI.MgStringCollection_GetItem(this.swigCPtr, n);
    }

    public void setItem(int n, String string) {
        MapGuideJavaApiExJNI.MgStringCollection_SetItem(this.swigCPtr, n, string);
    }

    public void addItem(String string) {
        MapGuideJavaApiExJNI.MgStringCollection_addItem(this.swigCPtr, string);
    }

    public void insert(int n, String string) {
        MapGuideJavaApiExJNI.MgStringCollection_Insert(this.swigCPtr, n, string);
    }

    @Override
    public void clear() {
        MapGuideJavaApiExJNI.MgStringCollection_Clear(this.swigCPtr);
    }

    public boolean remove(String string) {
        return MapGuideJavaApiExJNI.MgStringCollection_Remove(this.swigCPtr, string);
    }

    @Override
    public void removeAt(int n) {
        MapGuideJavaApiExJNI.MgStringCollection_RemoveAt(this.swigCPtr, n);
    }

    public boolean contains(String string) {
        return MapGuideJavaApiExJNI.MgStringCollection_Contains(this.swigCPtr, string);
    }

    public int indexOf(String string) {
        return MapGuideJavaApiExJNI.MgStringCollection_IndexOf(this.swigCPtr, string);
    }

    @Override
    public MgByteReader toXml() {
        long l = MapGuideJavaApiExJNI.MgStringCollection_ToXml(this.swigCPtr);
        return l == 0L ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(l), l, true);
    }

    class ItemIterator
    implements Iterator<String> {
        private MgStringCollection _collection;
        private int _pos;
        private int _count;

        public ItemIterator(MgStringCollection mgStringCollection2) {
            this._collection = mgStringCollection2;
            this._count = this._collection.getCount();
            this._pos = -1;
        }

        @Override
        public boolean hasNext() {
            return this._pos + 1 < this._count;
        }

        @Override
        public String next() {
            ++this._pos;
            if (this._pos >= this._count) {
                throw new NoSuchElementException();
            }
            return this._collection.getItem(this._pos);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

